uniform sampler2D 	tex;
uniform sampler2D 	depthTex;
varying vec4		t1,t2;
varying vec2		t0;

uniform float		farOffset;

void main()
{
	vec4 	c0,c1,c2,c3,c4,c5,c6;
	float 	d0,d1,d2,d3,d4,
		o0,o1,o2,o3;
	float 	count=1.0;
	vec4 	finalcolor;
	
	d0=-texture2D(depthTex,t0).r;
	c0=texture2D(tex, t0);
	
	finalcolor=c0;
	
	float farOffsetMin=farOffset-1500.0;
	float depthTolerance;
	if(d0<farOffsetMin)
		depthTolerance=min(d0*0.1,20.0);
	else
	{
		float t=( clamp( (d0-farOffsetMin)/(farOffset-farOffsetMin),0.0,1.0));
		float d=d0*0.1;
		depthTolerance=mix(min(d,20.0),min(d,200.0),t);
	}
	
	d1=-texture2D(depthTex,t1.xy).r;
	d2=-texture2D(depthTex,t1.zw).r;
	d3=-texture2D(depthTex,t2.xy).r;
	d4=-texture2D(depthTex,t2.zw).r;
	
	o0=clamp(depthTolerance-abs(d0-d1),0.0,1.0);
	o1=clamp(depthTolerance-abs(d0-d2),0.0,1.0);
	o2=clamp(depthTolerance-abs(d0-d3),0.0,1.0);
	o3=clamp(depthTolerance-abs(d0-d4),0.0,1.0);

	c1=texture2D(tex,t1.xy)*o0;		
	c2=texture2D(tex,t1.zw)*o1;
	c3=texture2D(tex,t2.xy)*o2;
	c4=texture2D(tex,t2.zw)*o3;

	count+=o0;
	count+=o1;
	count+=o2;
	count+=o3;
	
/////////////////////////////
			
	finalcolor=(c0+c1+c2+c3+c4)/count;
	gl_FragColor =  finalcolor;
}
